/*
 * Decompiled with CFR 0.152.
 */
package com.stevekung.fishofthieves.feature.blockpredicates;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.MapCodec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import com.stevekung.fishofthieves.registry.FOTBlockPredicateTypes;
import net.minecraft.core.BlockPos;
import net.minecraft.world.level.WorldGenLevel;
import net.minecraft.world.level.levelgen.blockpredicates.BlockPredicate;
import net.minecraft.world.level.levelgen.blockpredicates.BlockPredicateType;

public class BlockBrightnessPredicate
implements BlockPredicate {
    public static final MapCodec<BlockBrightnessPredicate> CODEC = RecordCodecBuilder.mapCodec(instance -> instance.group((App)Codec.intRange((int)0, (int)15).fieldOf("raw_brightness").forGetter(predicate -> predicate.rawBrightness)).apply((Applicative)instance, BlockBrightnessPredicate::new));
    private final int rawBrightness;

    private BlockBrightnessPredicate(int rawBrightness) {
        this.rawBrightness = rawBrightness;
    }

    public static BlockBrightnessPredicate value(int rawBrightness) {
        return new BlockBrightnessPredicate(rawBrightness);
    }

    public boolean test(WorldGenLevel worldGenLevel, BlockPos blockPos) {
        return worldGenLevel.getRawBrightness(blockPos, 0) >= this.rawBrightness;
    }

    public BlockPredicateType<?> type() {
        return FOTBlockPredicateTypes.BLOCK_BRIGHTNESS;
    }
}

